#ifndef _PINMUX_BOARD_H_
#define _PINMUX_BOARD_H_

/*
 * MODE0 - Mux Mode 0
 * MODE1 - Mux Mode 1
 * MODE2 - Mux Mode 2
 * MODE3 - Mux Mode 3
 * MODE4 - Mux Mode 4
 * MODE5 - Mux Mode 5
 * MODE6 - Mux Mode 6
 * MODE7 - Mux Mode 7
 * IDIS - Receiver disabled
 * IEN - Receiver enabled
 * PD - Internal pull-down
 * PU - Internal pull-up
 * OFF - Internal pull disabled
 */

#define MUX_EVM() \
MUX_VAL(CONTROL_PADCONF_GPMC_AD0, (IEN | PD | MODE0 )) /* gpmc_ad0 */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD1, (IEN | PD | MODE0 )) /* gpmc_ad1 */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD2, (IEN | PD | MODE0 )) /* gpmc_ad2 */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD3, (IEN | PD | MODE0 )) /* gpmc_ad3 */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD4, (IEN | PD | MODE0 )) /* gpmc_ad4 */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD5, (IEN | PD | MODE0 )) /* gpmc_ad5 */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD6, (IEN | PD | MODE0 )) /* gpmc_ad6 */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD7, (IEN | PD | MODE0 )) /* gpmc_ad7 */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD8, (IEN | PD | MODE7 )) /* gpio0[22] */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD9, (IEN | PD | MODE7 )) /* gpio0[23] */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD10, (IEN | PD | MODE7 )) /* gpio0[26] */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD11, (IEN | PD | MODE7 )) /* gpio0[27] */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD12, (IEN | PD | MODE7 )) /* gpio1[12] */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD13, (IEN | PD | MODE7 )) /* gpio1[13] */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD14, (IEN | PD | MODE7 )) /* gpio1[14] */\
MUX_VAL(CONTROL_PADCONF_GPMC_AD15, (IEN | PD | MODE7 )) /* gpio1[15] */\
MUX_VAL(CONTROL_PADCONF_GPMC_A0, (IEN | PD | MODE7 )) /* gpio1[16] */\
MUX_VAL(CONTROL_PADCONF_GPMC_A1, (IEN | PD | MODE7 )) /* gpio1[17] */\
MUX_VAL(CONTROL_PADCONF_GPMC_A2, (IEN | PD | MODE7 )) /* gpio1[18] */\
MUX_VAL(CONTROL_PADCONF_GPMC_A3, (IEN | PD | MODE7 )) /* gpio1[19] */\
MUX_VAL(CONTROL_PADCONF_GPMC_A4, (IEN | PD | MODE7 )) /* gpio1[20] */\
MUX_VAL(CONTROL_PADCONF_GPMC_A5, (IEN | PD | MODE7 )) /* gpio1[21] */\
MUX_VAL(CONTROL_PADCONF_GPMC_A6, (IEN | PD | MODE7 )) /* gpio1[22] */\
MUX_VAL(CONTROL_PADCONF_GPMC_A7, (IEN | PD | MODE7 )) /* gpio1[23] */\
MUX_VAL(CONTROL_PADCONF_GPMC_A8, (IEN | PD | MODE7 )) /* gpio1[24] */\
MUX_VAL(CONTROL_PADCONF_GPMC_A9, (IEN | PD | MODE7 )) /* gpio1[25] */\
MUX_VAL(CONTROL_PADCONF_GPMC_A10, (IEN | PD | MODE6 )) /* mcasp0_axr0_mux3 */\
MUX_VAL(CONTROL_PADCONF_GPMC_A11, (IEN | PD | MODE7 )) /* gpio1[27] */\
MUX_VAL(CONTROL_PADCONF_GPMC_WAIT0, (IEN | PU | MODE0 )) /* gpmc_wait0 */\
MUX_VAL(CONTROL_PADCONF_GPMC_WPN, (IDIS | PU | MODE0 )) /* gpmc_wpn */\
MUX_VAL(CONTROL_PADCONF_GPMC_BEN1, (IEN | PU | MODE7 )) /* gpio1[28] */\
MUX_VAL(CONTROL_PADCONF_GPMC_CSN0, (IDIS | PU | MODE0 )) /* gpmc_csn0 */\
MUX_VAL(CONTROL_PADCONF_GPMC_CSN1, (IEN | PU | MODE7 )) /* gpio1[30] */\
MUX_VAL(CONTROL_PADCONF_GPMC_CSN2, (IEN | PU | MODE7 )) /* gpio1[31] */\
MUX_VAL(CONTROL_PADCONF_GPMC_CSN3, (IEN | PU | MODE7 )) /* gpio2[0] */\
MUX_VAL(CONTROL_PADCONF_GPMC_CLK, (IEN | PD | MODE7 )) /* gpio2[1] */\
MUX_VAL(CONTROL_PADCONF_GPMC_ADVN_ALE, (IDIS | PU | MODE0 )) /* gpmc_advn_ale */\
MUX_VAL(CONTROL_PADCONF_GPMC_OEN_REN, (IDIS | PU | MODE0 )) /* gpmc_oen_ren */\
MUX_VAL(CONTROL_PADCONF_GPMC_WEN, (IDIS | PU | MODE0 )) /* gpmc_wen */\
MUX_VAL(CONTROL_PADCONF_GPMC_BEN0_CLE, (IDIS | PU | MODE0 )) /* gpmc_be0n_cle */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA0, (IEN | OFF | MODE0 )) /* lcd_data0 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA1, (IEN | OFF | MODE0 )) /* lcd_data1 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA2, (IEN | OFF | MODE0 )) /* lcd_data2 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA3, (IEN | OFF | MODE0 )) /* lcd_data3 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA4, (IEN | OFF | MODE0 )) /* lcd_data4 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA5, (IEN | OFF | MODE0 )) /* lcd_data5 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA6, (IEN | OFF | MODE0 )) /* lcd_data6 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA7, (IEN | OFF | MODE0 )) /* lcd_data7 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA8, (IEN | OFF | MODE0 )) /* lcd_data8 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA9, (IEN | OFF | MODE0 )) /* lcd_data9 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA10, (IEN | OFF | MODE0 )) /* lcd_data10 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA11, (IEN | OFF | MODE0 )) /* lcd_data11 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA12, (IEN | OFF | MODE0 )) /* lcd_data12 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA13, (IEN | OFF | MODE0 )) /* lcd_data13 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA14, (IEN | OFF | MODE0 )) /* lcd_data14 */\
MUX_VAL(CONTROL_PADCONF_LCD_DATA15, (IEN | OFF | MODE0 )) /* lcd_data15 */\
MUX_VAL(CONTROL_PADCONF_LCD_VSYNC, (IDIS | OFF | MODE0 )) /* lcd_vsync */\
MUX_VAL(CONTROL_PADCONF_LCD_HSYNC, (IDIS | OFF | MODE0 )) /* lcd_hsync */\
MUX_VAL(CONTROL_PADCONF_LCD_PCLK, (IDIS | OFF | MODE0 )) /* lcd_pclk */\
MUX_VAL(CONTROL_PADCONF_LCD_AC_BIAS_EN, (IDIS | OFF | MODE0 )) /* lcd_ac_bias_en */\
MUX_VAL(CONTROL_PADCONF_MMC0_DAT3, (IEN | PU | MODE0 )) /* mmc0_dat3 */\
MUX_VAL(CONTROL_PADCONF_MMC0_DAT2, (IEN | PU | MODE0 )) /* mmc0_dat2 */\
MUX_VAL(CONTROL_PADCONF_MMC0_DAT1, (IEN | PU | MODE0 )) /* mmc0_dat1 */\
MUX_VAL(CONTROL_PADCONF_MMC0_DAT0, (IEN | PU | MODE0 )) /* mmc0_dat0 */\
MUX_VAL(CONTROL_PADCONF_MMC0_CLK, (IEN | PU | MODE0 )) /* mmc0_clk */\
MUX_VAL(CONTROL_PADCONF_MMC0_CMD, (IEN | PU | MODE0 )) /* mmc0_cmd */\
MUX_VAL(CONTROL_PADCONF_MII1_COL, (IEN | PD | MODE5 )) /* mmc2_dat3_mux2 */\
MUX_VAL(CONTROL_PADCONF_MII1_CRS, (IEN | PD | MODE7 )) /* gpio3[1] */\
MUX_VAL(CONTROL_PADCONF_MII1_RX_ER, (IEN | PD | MODE7 )) /* gpio3[2] */\
MUX_VAL(CONTROL_PADCONF_MII1_TX_EN, (IEN | PD | MODE6 )) /* mmc2_cmd_mux2 */\
MUX_VAL(CONTROL_PADCONF_MII1_RX_DV, (IEN | PD | MODE5 )) /* mmc2_dat0_mux2 */\
MUX_VAL(CONTROL_PADCONF_MII1_TXD3, (IEN | PD | MODE5 )) /* mmc2_dat1_mux2 */\
MUX_VAL(CONTROL_PADCONF_MII1_TXD2, (IEN | PD | MODE5 )) /* mmc2_dat2_mux2 */\
MUX_VAL(CONTROL_PADCONF_MII1_TXD1, (IEN | PD | MODE7 )) /* gpio0[21] */\
MUX_VAL(CONTROL_PADCONF_MII1_TXD0, (IEN | PD | MODE7 )) /* gpio0[28] */\
MUX_VAL(CONTROL_PADCONF_MII1_TX_CLK, (IEN | PD | MODE6 )) /* mcasp0_aclkx_mux2 */\
MUX_VAL(CONTROL_PADCONF_MII1_RX_CLK, (IEN | PD | MODE6 )) /* mcasp0_fsx_mux2 */\
MUX_VAL(CONTROL_PADCONF_MII1_RXD3, (IEN | PD | MODE1 )) /* uart3_rxd_mux0 */\
MUX_VAL(CONTROL_PADCONF_MII1_RXD2, (IDIS | PD | MODE1 )) /* uart3_txd_mux0 */\
MUX_VAL(CONTROL_PADCONF_MII1_RXD1, (IEN | PD | MODE6 )) /* mmc2_clk_mux2 */\
MUX_VAL(CONTROL_PADCONF_MII1_RXD0, (IEN | PD | MODE6 )) /* mcasp0_axr3_mux4 */\
MUX_VAL(CONTROL_PADCONF_RMII1_REF_CLK, (IEN | PD | MODE7 )) /* gpio0[29] */\
MUX_VAL(CONTROL_PADCONF_MDIO, (IEN | PU | MODE3 )) /* uart3_ctsn_mux2 */\
MUX_VAL(CONTROL_PADCONF_MDC, (IDIS | PU | MODE3 )) /* uart3_rtsn_mux2 */\
MUX_VAL(CONTROL_PADCONF_SPI0_SCLK, (IEN | OFF | MODE1 )) /* uart2_rxd_mux3 */\
MUX_VAL(CONTROL_PADCONF_SPI0_D0, (IDIS | OFF | MODE1 )) /* uart2_txd_mux3 */\
MUX_VAL(CONTROL_PADCONF_SPI0_D1, (IEN | OFF | MODE2 )) /* I2C1_SDA_mux3 */\
MUX_VAL(CONTROL_PADCONF_SPI0_CS0, (IEN | OFF | MODE2 )) /* I2C1_SCL_mux3 */\
MUX_VAL(CONTROL_PADCONF_SPI0_CS1, (IEN | OFF | MODE2 )) /* eCAP1_in_PWM1_out_mux0 */\
/*MUX_VAL(CONTROL_PADCONF_ECAP0_IN_PWM0_OUT, (IEN | OFF | MODE0 ))*/ /* eCAP0_in_PWM0_out */\
MUX_VAL(CONTROL_PADCONF_UART0_CTSN, (IEN | OFF | MODE0 )) /* uart0_ctsn */\
MUX_VAL(CONTROL_PADCONF_UART0_RTSN, (IEN | OFF | MODE0 )) /* uart0_rtsn */\
MUX_VAL(CONTROL_PADCONF_UART0_RXD, (IEN | PU | MODE0 )) /* uart0_rxd */\
MUX_VAL(CONTROL_PADCONF_UART0_TXD, (IEN | PU | MODE0 )) /* uart0_txd */\
MUX_VAL(CONTROL_PADCONF_UART1_CTSN, (IEN | OFF | MODE0 )) /* uart1_ctsn */\
MUX_VAL(CONTROL_PADCONF_UART1_RTSN, (IDIS | OFF | MODE0 )) /* uart1_rtsn */\
MUX_VAL(CONTROL_PADCONF_UART1_RXD, (IEN | PU | MODE0 )) /* uart1_rxd */\
MUX_VAL(CONTROL_PADCONF_UART1_TXD, (IDIS | PU | MODE0 )) /* uart1_txd */\
MUX_VAL(CONTROL_PADCONF_I2C0_SDA, (IEN | OFF | MODE0 )) /* I2C0_SDA */\
MUX_VAL(CONTROL_PADCONF_I2C0_SCL, (IEN | OFF | MODE0 )) /* I2C0_SCL */\
MUX_VAL(CONTROL_PADCONF_MCASP0_ACLKX, (IEN | PD | MODE3 )) /* spi1_sclk_mux2 */\
MUX_VAL(CONTROL_PADCONF_MCASP0_FSX, (IEN | PD | MODE3 )) /* spi1_d0_mux2 */\
MUX_VAL(CONTROL_PADCONF_MCASP0_AXR0, (IEN | PD | MODE3 )) /* spi1_d1_mux2 */\
MUX_VAL(CONTROL_PADCONF_MCASP0_AHCLKR, (IEN | PD | MODE3 )) /* spi1_cs0_mux4 */\
MUX_VAL(CONTROL_PADCONF_MCASP0_ACLKR, (IEN | PD | MODE7 )) /* gpio3[18] */\
MUX_VAL(CONTROL_PADCONF_MCASP0_FSR, (IEN | PD | MODE7 )) /* gpio3[19] */\
MUX_VAL(CONTROL_PADCONF_MCASP0_AXR1, (IEN | OFF | MODE7 )) /* gpio3[20] */\
MUX_VAL(CONTROL_PADCONF_MCASP0_AHCLKX, (IEN | PD | MODE7 )) /* gpio3[21] */\
MUX_VAL(CONTROL_PADCONF_XDMA_EVENT_INTR0, (IEN | OFF | MODE7 )) /* gpio0[19] */\
MUX_VAL(CONTROL_PADCONF_XDMA_EVENT_INTR1, (IEN | OFF | MODE7 )) /* gpio0[20] */\
MUX_VAL(CONTROL_PADCONF_WARMRSTN, (IEN | OFF | MODE0 )) /* nRESETIN_OUT */\
MUX_VAL(CONTROL_PADCONF_EXTINTN, (IEN | OFF | MODE0 )) /* nNMI */\
MUX_VAL(CONTROL_PADCONF_TMS, (IEN | PU | MODE0 )) /* TMS */\
MUX_VAL(CONTROL_PADCONF_TDI, (IEN | PU | MODE0 )) /* TDI */\
MUX_VAL(CONTROL_PADCONF_TDO, (IDIS | PU | MODE0 )) /* TDO */\
MUX_VAL(CONTROL_PADCONF_TCK, (IEN | PU | MODE0 )) /* TCK */\
MUX_VAL(CONTROL_PADCONF_TRSTN, (IEN | PD | MODE0 )) /* nTRST */\
MUX_VAL(CONTROL_PADCONF_EMU0, (IEN | PU | MODE0 )) /* EMU0 */\
MUX_VAL(CONTROL_PADCONF_EMU1, (IEN | PU | MODE0 )) /* EMU1 */\
MUX_VAL(CONTROL_PADCONF_RTC_PWRONRSTN, (IEN | OFF | MODE0 )) /* RTC_porz */\
MUX_VAL(CONTROL_PADCONF_PMIC_POWER_EN, (IDIS | PU | MODE0 )) /* PMIC_POWER_EN */\
MUX_VAL(CONTROL_PADCONF_EXT_WAKEUP, (IEN | PD | MODE0 )) /* EXT_WAKEUP */\
MUX_VAL(CONTROL_PADCONF_RTC_KALDO_ENN, (IEN | OFF | MODE0 )) /* ENZ_KALDO_1P8V */\
//MUX_VAL(CONTROL_PADCONF_USB0_DRVVBUS, (IEN | OFF | MODE7 )) /* gpio0[18] */\
//MUX_VAL(CONTROL_PADCONF_USB1_DRVVBUS, (IDIS | OFF | MODE7 )) /* USB1_DRVVBUS gpio3[13] */\

#endif
